if (!etcs) { var etcs = {}; }

etcs.headerText = "";

etcs.dataOptions = {
	baseline:   "", 			// 3M1 | 32
	version:    "10-11-20-21", 	// 10-11-20-21
	level:      "0-N-1-2-3", 	// 0-N-1-2-3
	transition: "0-N-1-2-3", 	// 0-N-1-2-3
	screen:     "" 				// S | T
};

etcs.dataIndex = [
{
	code: 'INT', name: 'Einführung (INT)', active: true, level2: [
		{
			code: 'INT.SCP', name: 'Umfang und Verwendungszweck (SCP)', active: true
		},
		{
			code: 'INT.TER', name: 'Begriffe und Abkürzungen (TER)', active: true
		},
		{
			code: 'INT.COD', name: 'Codes und Symbole (COD)', active: true
		},
		{
			code: 'INT.REF', name: 'Referenzdokumente (REF)', active: true
		}
	]
},
{
	code: 'CNT', name: 'ETCS-Bedienelemente (CNT)', active: true, level2: [
		{
			code: 'CNT.SWT', name: 'Schalter und Bedienelemente für ETCS (SWT)', active: true
		},
		{
			code: 'CNT.DMI', name: 'Driver Machine Interface (DMI)', active: true, level3: [
				{ code: 'CNT.DMI.GEN', name: 'Allgemeine Beschreibung (GEN)', active: true },
				{ code: 'CNT.DMI.BUT', name: 'Schaltflächen/Tasten (BUT)', active: true },
				{ code: 'CNT.DMI.SYM', name: 'Symbole (SYM)', active: true },
				{ code: 'CNT.DMI.AUD', name: 'Akustische Informationen (AUD)', active: true },
				{ code: 'CNT.DMI.SME', name: 'Systemmeldungen (SME)', active: true },
				{ code: 'CNT.DMI.SPD', name: 'Geschwindigkeits- und Überwachungsinformationen (SPD)', active: true },
				{ code: 'CNT.DMI.PLN', name: 'Vorschaubereich (PLN)', active: true },
				{ code: 'CNT.DMI.NTC', name: 'NTC-Informationen (NTC)', active: true, restriction: [{l:'N'}] },
				{ code: 'CNT.DMI.LNG', name: 'Sprachauswahl vom Triebfahrzeugführer (LNG)', active: true },
				{ code: 'CNT.DMI.VOL', name: 'Lautsprechereinstellung (VOL)', active: true },
				{ code: 'CNT.DMI.BRI', name: 'Helligkeitseinstellung (BRI)', active: true },
				{ code: 'CNT.DMI.SYV', name: 'Betriebene Systemversion (SYV)', active: true },
				{ code: 'CNT.DMI.DV', name: 'Datenansicht (DV)', active: true }
			]
		}
	]
},
{
	code: 'EI', name: 'Europäische Anweisungen (EI)', active: true
},
{
	code: 'NP', name: 'No Power (NP)', active: true, level2: [
		{
			code: 'NP.ON', name: 'Einschalten des fahrzeugseitigen ETCS (ON)', active: true
		}
	]
},
{
	code: 'SB', name: 'Stand By (SB)', active: true, level2: [
		{
			code: 'SB.OPN', name: 'Das Führerpult öffnen (OPN)', active: true
		},
		{
			code: 'SB.TST', name: 'Interne Tests (TST)', active: true
		},
		{
			code: 'SB.DRV', name: 'Triebfahrzeugführer-Identifikation eingeben oder neu quittieren (DRV)', active: true
		},
		{
			code: 'SB.TN', name: 'Zugnummer eingeben oder neu quittieren (TN)', active: true
		},
		{
			code: 'SB.VBC', name: 'Virtuelle Balisenabdeckung (VBC) eingeben oder neu quittieren', active: true
		},
		{
			code: 'SB.LEV', name: 'ETCS-Level eingeben oder neu quittieren (LEV)', active: true
		},
		{
			code: 'SB.RAD', name: 'Funkinformation eingeben oder neu quittieren (RAD)', active: true
		},
		{
			code: 'SB.TRN', name: 'Fahrzeug muss sich als ein Zug bewegen (TRN)', active: true, level3: [
				{ code: 'SB.TRN.DAT', name: 'Zugdaten eingeben oder neu quittieren (DAT)', active: true },
				{ code: 'SB.TRN.STR', name: 'Start auswählen (STR)', active: true },
				{ code: 'SB.TRN.OVR', name: 'Override auswählen (OVR)', active: true }
			]
		},
		{
			code: 'SB.SH', name: 'Das Fahrzeug muss sich in SH bewegen (SH)', active: true
		},
		{
			code: 'SB.NL', name: 'Fahrzeug muss sich in NL bewegen (NL)', active: true
		}
	]
},
{
	code: 'SH', name: 'Shunting (SH)', active: true, level2: [
		{
			code: 'SH.MAN', name: 'Manuelle Eingabe in SH (MAN)', active: true, level3: [
				{ code: 'SH.MAN.RUL', name: 'Regeln, um SH auszuwählen (RUL)', active: true, restriction: [{l:'123'}] },
				{ code: 'SH.MAN.SEL', name: 'SH Auswahl (SEL)', active: true }
			]
		},
		{
			code: 'SH.AUT', name: 'Automatische Aufnahme in SH (AUT)', active: true, level3: [
				{ code: 'SH.AUT.APP', name: 'Annäherung an einen SH-Bereich (APP)', active: true },
				{ code: 'SH.AUT.ACK', name: 'Quittierung der Betriebsart SH (ACK)', active: true }
			]
		},
		{
			code: 'SH.OPN', name: 'Ein Führerpult in SH öffnen (OPN)', active: true
		},
		{
			code: 'SH.PS', name: 'SH beibehalten beim Wechseln des Führerraums (PS)', active: true
		},
		{
			code: 'SH.RUN', name: 'Fahrend in SH (RUN)', active: true
		},
		{
			code: 'SH.EXT', name: 'Beenden des SH (EXT)', active: true
		}
	]
},
{
	code: 'FS', name: 'Full Supervision (FS)', active: true, restriction: [{l:'123'}], level2: [
		{
			code: 'FS.RUN', name: 'Fahrend im FS (RUN)', active: true, restriction: [{l:'123'}]
		}
	]
},
{
	code: 'LS', name: 'Limited Supervision (LS)', active: true, restriction: [{v:'2021', l:'123'}], level2: [
		{
			code: 'LS.APP', name: 'Annäherung an einen LS-Bereich (APP)', active: true
		},
		{
			code: 'LS.ACK', name: 'Quittierung der Betriebsart LS (ACK)', active: true
		},
		{
			code: 'LS.RUN', name: 'Fahrend im LS (RUN)', active: true
		}
	]
},
{
	code: 'SR', name: 'Staff responsible (SR)', active: true, restriction: [{l:'123'}], level2: [
		{
			code: 'SR.ACK', name: 'Quittierung der Betriebsart SR (ACK)', active: true
		},
		{
			code: 'SR.LIM', name: 'Ändern der SR-Geschwindigkeit und Entfernungsgrenzen(LIM)', active: true
		},
		{
			code: 'SR.RUN', name: 'Fahrend in SR (RUN)', active: true
		}
	]
},
{
	code: 'OS', name: 'On sight (OS)', active: true, restriction: [{l:'123'}], level2: [
		{
			code: 'OS.APP', name: 'Annäherung an einen OS-Bereich (APP)', active: true
		},
		{
			code: 'OS.ACK', name: 'Quittierung der Betriebsart OS (ACK)', active: true
		},
		{
			code: 'OS.RUN', name: 'Fahrend im OS (RUN)', active: true
		}
	]
},
{
	code: 'SL', name: 'Sleeping (SL)', active: true
},
{
	code: 'NL', name: 'Non-Leading (NL)', active: true
},
{
	code: 'UN', name: 'Unfitted (UN)', active: true, restriction: [{l:'0'}]
},
{
	code: 'TR', name: 'Trip / Post Trip (TR)', active: true, level2: [
		{
			code: 'TR.MSR', name: 'Sofortige Maßnahmen (MSR)', active: true
		},
		{
			code: 'TR.CON', name: 'Eine Mission nach einem Train Trip fortsetzen (CON)', active: true
		}
	]
},
{
	code: 'SF', name: 'System Failure (SF)', active: true
},
{
	code: 'IS', name: 'Isolation (IS)', active: true, level2: [
		{
			code: 'IS.ENT', name: 'Aufnahme in die Betriebsart Isolation (ENT)', active: true
		},
		{
			code: 'IS.EXT', name: 'Beenden der Betriebsart Isolation (EXT)', active: true
		}
	]
},
{
	code: 'SN', name: 'National System (SN)', active: true, restriction: [{l:'N'}]
},
{
	code: 'RV', name: 'Reversing (RV)', active: true, restriction: [{l:'123'}], level2: [
		{
			code: 'RV.ENT', name: 'Aufnahme in die Betriebsart RV (ENT)', active: true
		},
		{
			code: 'RV.RUN', name: 'Fahrend im RV (RUN)', active: true
		},
		{
			code: 'RV.EXT', name: 'Beenden des RV (EXT)', active: true
		}
	]
},
{
	code: 'LTR', name: 'Aufnahme und bedienen in einem Level (LTR)', active: true, level2: [
		{
			code: 'LTR.LEV', name: 'Levels (LEV)', active: true, level3: [
				{ code: 'LTR.LEV.L0', name: 'Fahren im Level 0 (L0)', active: true, restriction: [{l:'0'}] },
				{ code: 'LTR.LEV.NTC', name: 'Fahren im Level NTC (NTC)', active: true, restriction: [{l:'N'}] },
				{ code: 'LTR.LEV.L1', name: 'Fahren im Level 1 (L1)', active: true, restriction: [{l:'1'}] },
				{ code: 'LTR.LEV.L2', name: 'Fahren im Level 2 (L2)', active: true, restriction: [{l:'2'}] },
				{ code: 'LTR.LEV.L3', name: 'Fahren im Level 3 (L3)', active: true, restriction: [{l:'3'}] }
			]
		},
		{
			code: 'LTR.TRS', name: 'Levelwechsel (TRS)', active: true, level3: [
				{ code: 'LTR.TRS.TL0', name: 'Durch die Strecke angeordneter Levelwechsel nach Level 0 (TL0)', active: true, restriction: [{t:'0'}] },
				{ code: 'LTR.TRS.NTC', name: 'Durch die Strecke angeordneter Levelwechsel nach Level NTC (NTC)', active: true, restriction: [{t:'N'}]  },
				{ code: 'LTR.TRS.TL1', name: 'Durch die Strecke angeordneter Levelwechsel nach Level 1 (TL1)', active: true, restriction: [{t:'1'}]  },
				{ code: 'LTR.TRS.TL2', name: 'Durch die Strecke angeordneter Levelwechsel nach Level 2 (TL2)', active: true, restriction: [{t:'2'}]  },
				{ code: 'LTR.TRS.TL3', name: 'Durch die Strecke angeordneter Levelwechsel nach Level 3 (TL3)', active: true, restriction: [{t:'3'}]  },
				{ code: 'LTR.TRS.DRV', name: 'Vom Triebfahrzeugführer eingeleiteter Levelwechsel (DRV)', active: true }
			]
		}
	]
},
{
	code: 'LX', name: 'Bahnübergang (LX)', active: true, restriction: [{v:'2021', l:'123'}]
},
{
	code: 'TKC', name: 'Angekündigte Streckenzustände (TKC)', active: true, restriction: [{l:'123'}], level2: [
		{
			code: 'TKC.PNT', name: 'Durchfahren eines Abschnitts mit gesenktem Stromabnehmer/gesenkten Stromabnehmern (PNT)', active: true
		},
		{
			code: 'TKC.PWR', name: 'Ändern der elektrischen Stromversorgung (PWR)', active: true
		},
		{
			code: 'TKC.SWT', name: 'Überfahren eines Abschnitts mit ausgeschaltetem Hauptstromschalter (SWT)', active: true
		},
		{
			code: 'TKC.NST', name: 'Überfahren eines Nicht-Haltebereichs (NST)', active: true
		},
		{
			code: 'TKC.MAG', name: 'Überfahren eines Abschnitts mit Deaktivierung der Magnetschienenbremse (MAG)', active: true
		},
		{
			code: 'TKC.CUR', name: 'Überfahren eines Abschnitts mit Aktivierung der Wirbelstrombremse (CUR)', active: true
		},
		{
			code: 'TKC.REG', name: 'Überfahren eines Abschnitts mit Deaktivierung der Nutzbremse (REG)', active: true
		},
		{
			code: 'TKC.PRE', name: 'Überfahren eines Druckdichtungsabschnitts (PRE)', active: true
		},
		{
			code: 'TKC.SND', name: 'Ertönen der akustischen Warnvorrichtung (SND)', active: true
		},
		{
			code: 'TKC.RAD', name: 'Fahren durch ein Funkloch (RAD)', active: true, restriction: [{l:'23'}]
		},
		{
			code: 'TKC.STP', name: 'Halten in einem sicheren Bereich (STP)', active: true
		}
	]
},
{
	code: 'APP', name: 'Annäherung an ein EOA, Signal oder eine Signaltafel (Markerboard) (APP)', active: true, level2: [
		{
			code: 'APP.RS', name: 'Annäherung an ein EOA mit Release Speed-Angabe (RS)', active: true, restriction: [{l:'123'}]
		},
		{
			code: 'APP.SM', name: 'ETCS-Haltesignal (SM)', active: true
		},
		{
			code: 'APP.LM', name: 'ETCS-Location-Marker (SM)', active: true
		}
	]
},
{
	code: 'OVR', name: 'Genehmigung für das Überfahren eines EOA (OVR)', active: true, level2: [
		{
			code: 'OVR.RUL', name: 'Vorschriften, um ein EOA zu überfahren (RUL)', active: true
		},
		{
			code: 'OVR.USE', name: 'Override-Funktion benutzen (USE)', active: true
		}
	]
},
{
	code: 'OTH', name: 'Andere Verfahren (OTH)', active: true, level2: [
		{
			code: 'OTH.TAF', name: 'Gleis frei (TAF)', active: true, restriction: [{l:'23'}]
		},
		{
			code: 'OTH.DAT', name: 'Ändern der Zugdaten (DAT)', active: true, level3: [
				{ code: 'OTH.DAT.MAN', name: 'Manuelles Ändern der Zugdaten (MAN)', active: true },
				{ code: 'OTH.DAT.EXT', name: 'Änderung der Zugdaten durch externe ETCS-Quellen (EXT)', active: true }
			]
		},
		{
			code: 'OTH.ODA', name: 'Ändern von anderen Daten (ODA)', active: true, level3: [
				{ code: 'OTH.ODA.DRV', name: 'Änderung der Triebfahrzeugführer-Identifikation (DRV)', active: true },
				{ code: 'OTH.ODA.TN', name: 'Änderung der Zugnummer (TN)', active: true },
				{ code: 'OTH.ODA.RAD', name: 'Änderung der Funkinformation (RAD)', active: true }
			]
		},
		{
			code: 'OTH.ADH', name: 'Ändern des Reibwerts (ADH)', active: true
		},
		{
			code: 'OTH.ORN', name: 'Ändern der Zugrichtung (ORN)', active: true
		},
		{
			code: 'OTH.JOI', name: 'Kuppeln (JOI)', active: true
		},
		{
			code: 'OTH.SPL', name: 'TRENNEN (SPL)', active: true
		},
		{
			code: 'OTH.TXT', name: 'Textmeldung von der Strecke (TXT)', active: true
		},
		{
			code: 'OTH.BRK', name: 'Umgang mit dem Bremsbefehl (BRK)', active: true, level3: [
				{ code: 'OTH.BRK.UNI', name: 'Reagieren auf unabsichtliche Bewegungen (UNI)', active: true, restriction: [{l:'123'}] }
			]
		},
		{
			code: 'OTH.INT', name: 'Bestätigung des Triebfahrzeugführers der Zugvollständigkeit (INT)', active: true
		},
		{
			code: 'OTH.GEO', name: 'Geografische Positionsmeldung (GEO)', active: true
		}
	]
},
{
	code: 'NFN', name: 'Nationale Funktionen (NFN)', active: true
},
{
	code: 'DEG', name: 'Gestörte Situationen (DEG)', active: true, level2: [
		{
			code: 'DEG.UNS', name: 'Verwalten einer ungeeigneten Strecke (UNS)', active: true, restriction: [{l:'123'}]
		},
		{
			code: 'DEG.TRK', name: 'Verwalten einer streckenseitigen Störung (TRK)', active: true, restriction: [{l:'123'}]
		},
		{
			code: 'DEG.VER', name: 'Verwalten der Inkompatibilität der Systemversion (VER)', active: true, restriction: [{l:'123'}]
		},
		{
			code: 'DEG.BLS', name: 'Verwalten eines Balisen-Lesefehlers (BLS)', active: true, restriction: [{l:'123'}]
		},
		{
			code: 'DEG.BMM', name: 'Verwalten einer Balisentransmissionsstörung (BMM)', active: true
		},
		{
			code: 'DEG.SMA', name: 'Verwalten einer MA-Verkürzung (SMA)', active: true
		},
		{
			code: 'DEG.TR', name: 'Übergang in die Betriebsart Trip (TR)', active: true
		},
		{
			code: 'DEG.LTR', name: 'Verwalten eines fehlgeschlagenen Levelwechsels (LRT)', active: true, restriction: [{l:'123'}]
		},
		{
			code: 'DEG.MDT', name: 'Verwalten eines Fehlens eines Levelübergangs (MDT)', active: true
		},
		{
			code: 'DEG.RBC', name: 'Verwalten eines Fehlens einer RBC-Information (RBC)', active: true, restriction: [{l:'23'}]
		},
		{
			code: 'DEG.COM', name: 'Verwalten eines Funkkommunikationsfehlers (COM)', active: true
		},
		{
			code: 'DEG.TST', name: 'Verwalten eines Selbsttestfehlers (TST)', active: true
		},
		{
			code: 'DEG.RAD', name: 'Verwalten eines Fehlers, der die fahrzeugseitige Funkausrüstung betrifft (RAD)', active: true
		},
		{
			code: 'DEG.DMI', name: 'Verwalten einer DMI mit leerem Bildschirm (DMI)', active: true
		},
		{
			code: 'DEG.NTC', name: 'Verwalten eines NTC-Fehlers (NTC)', active: true
		}
	]
},
{
	code: 'OFF', name: 'Abschaltung des Systems (OFF)', active: true, level2: [
		{
			code: 'OFF.CLS', name: 'Das Führerpult schließen (CLS)', active: true
		},
		{
			code: 'OFF.PWR', name: 'Ausschalten des fahrzeugseitigen ETCS (PWR)', active: true
		}
	]
},
{
	code: 'CBS', name: 'Class-B-System (CBS)', active: true, level2: [
		{
			code: 'CBS.CNT', name: 'Bedienelemente (CNT)', active: true
		},
		{
			code: 'CBS.ON', name: 'Einschalten (ON)', active: true
		},
		{
			code: 'CBS.SH', name: 'Rangierfahrten (SH)', active: true
		},
		{
			code: 'CBS.OVR', name: 'Durchfahren eines restriktiven Signals (OVR)', active: true
		},
		{
			code: 'CBS.OS', name: 'Fahrten auf Sicht (OS)', active: true
		},
		{
			code: 'CBS.BRK', name: 'Bremseingriff (BRK)', active: true
		},
		{
			code: 'CBS.RV', name: 'Rückwärtsfahrten (RV)', active: true
		},
		{
			code: 'CBS.OTH', name: 'Andere Verfahren (OTH)', active: true
		},
		{
			code: 'CBS.DEG', name: 'Gestörte Situationen (DEG)', active: true
		},
		{
			code: 'CBS.OFF', name: 'Abschaltung (OFF)', active: true
		}
	]
}
];