if (!etcs) { var etcs = {} ; }

etcs.label = {
	selOption: 		"Bitte wählen Sie eine Option aus",
	selOptions: 	"Bitte wählen Sie mindestens eine Option aus",
	txtValues: 		"Prüfen Sie Ihre Werte",
	showEye:		"satzcodierung zeigen",
	hideEye:		"satzcodierung ausblenden",
};

etcs.prop = {
	sepChar: 			"-",
	filterStorageName:	"etcsdh_filter",
	eyeStorageName:		"etcsdh_eye",
	htmlExt:			".html",
	imgMenuPlus:		"img/ico_mas.png",
	imgMenuPlusSecond:	"img/ico_mas2.png",
	tooltip:			"tooltp",
	preconfigured:		false,
	showNameClauses:	false,
	aVer:				['10','11','20','21','1011','1020','1021','1120','1121','2021','101120','101121','112021','10112021'],
	aLev:				['0','N','1','2','3','0N','01','02','03','N1','N2','N3','12','13','23','0N1','0N2','0N3','012','013','023','N12','N13','N23','123','0N12','0N13','0N23','0123','N123','0N123']
};

etcs.funct = {
	
	onReady: function() {
		if (etcs.dataOptions != undefined) {
			etcs.prop.preconfigured = etcs.funct.isConfigured();
		}
		if (etcs.headerText != undefined && etcs.headerText.length > 0) {
			$("#txtHeader").html(etcs.headerText);
		}
		if (!etcs.prop.preconfigured) {
			var data = etcs.funct.readStoredData(etcs.prop.filterStorageName);
			if (data != null) {
				etcs.dataOptions.baseline = data.hB;
				etcs.dataOptions.version = etcs.funct.deleteSlash(data.hV);
				etcs.dataOptions.level = etcs.funct.deleteSlash(data.hL);
				etcs.dataOptions.transition = etcs.funct.deleteSlash(data.hT);
				etcs.dataOptions.screen = data.hS;
			} else {
				if (document.location.search.length > 0) {
					$("a").on("click", function() {
						var hashPos = this.href.indexOf("#");
						this.href = (hashPos > 0) ? this.href.substr(0, hashPos) + document.location.search + this.href.substr(hashPos) : this.href + document.location.search;
					});
					etcs.dataOptions.baseline = etcs.funct.getParameterByName("hBaseline");
					etcs.dataOptions.version = etcs.funct.deleteSlash(etcs.funct.getParameterByName("hVersion"));
					etcs.dataOptions.level = etcs.funct.deleteSlash(etcs.funct.getParameterByName("hLevel"));
					etcs.dataOptions.transition = etcs.funct.deleteSlash(etcs.funct.getParameterByName("hTransition"));
					etcs.dataOptions.screen = etcs.funct.getParameterByName("hScreen");
				}
			}
		}
		var showNameClauses = etcs.funct.readStoredData(etcs.prop.eyeStorageName);
		if (showNameClauses != null) {
			if (showNameClauses.showNameClauses != undefined) {
				etcs.prop.showNameClauses = showNameClauses.showNameClauses;
			}
		}
	},

	onReadyHome: function() {
		$("#iagree").on("click", function() {
			var doc = "filter.html";
			if (etcs.prop.preconfigured) {
				doc = "menu.html?hBaseline=" + etcs.dataOptions.baseline + "&hVersion=" + etcs.dataOptions.baseline + "&hLevel=" + etcs.dataOptions.level +"&hTransition=" + etcs.dataOptions.transition + "&hScreen=" + etcs.dataOptions.screen;
			}
			document.location.href = "content/" + doc;
		});
	},

	restrictMenu: function(restriction) {
		var isRestricted = false;
		if (restriction != undefined) {
			for (var i=0; i<restriction.length; i++) {
				var baselineRestricted = false;
				if (restriction[i].b != undefined) {
					baselineRestricted = (etcs.dataOptions.baseline != restriction[i].b);
				}
				var versionRestricted = false;
				if (restriction[i].v != undefined) {
					versionRestricted = true;
					var aVersion = etcs.dataOptions.version.split(etcs.prop.sepChar);
					switch (aVersion.length) {
						case 4: if (restriction[i].v.indexOf(aVersion[0]) >= 0 || restriction[i].v.indexOf(aVersion[1]) >= 0 || restriction[i].v.indexOf(aVersion[2]) >= 0 || restriction[i].v.indexOf(aVersion[3]) >= 0) { versionRestricted = false; } break;
						case 3: if (restriction[i].v.indexOf(aVersion[0]) >= 0 || restriction[i].v.indexOf(aVersion[1]) >= 0 || restriction[i].v.indexOf(aVersion[2]) >= 0) { versionRestricted = false; }break;
						case 2: if (restriction[i].v.indexOf(aVersion[0]) >= 0 || restriction[i].v.indexOf(aVersion[1]) >= 0) { versionRestricted = false; } break;
						default: if (restriction[i].v.indexOf(etcs.dataOptions.version) >=0) { versionRestricted = false; }
					}
				}
				var levelRestricted = false;
				if (restriction[i].l != undefined) {
					levelRestricted = true;
					var aLevel = etcs.dataOptions.level.split(etcs.prop.sepChar);
					switch (aLevel.length) {
						case 5: if (restriction[i].l.indexOf(aLevel[0]) >= 0 || restriction[i].l.indexOf(aLevel[1]) >= 0 || restriction[i].l.indexOf(aLevel[2]) >= 0 || restriction[i].l.indexOf(aLevel[3]) >= 0 || restriction[i].l.indexOf(aLevel[4]) >= 0) { levelRestricted = false; } break;
						case 4: if (restriction[i].l.indexOf(aLevel[0]) >= 0 || restriction[i].l.indexOf(aLevel[1]) >= 0 || restriction[i].l.indexOf(aLevel[2]) >= 0 || restriction[i].l.indexOf(aLevel[3]) >= 0) { levelRestricted = false; } break;
						case 3: if (restriction[i].l.indexOf(aLevel[0]) >= 0 || restriction[i].l.indexOf(aLevel[1]) >= 0 || restriction[i].l.indexOf(aLevel[2]) >= 0) { levelRestricted = false; }break;
						case 2: if (restriction[i].l.indexOf(aLevel[0]) >= 0 || restriction[i].l.indexOf(aLevel[1]) >= 0) { levelRestricted = false; } break;
						default: if (restriction[i].l.indexOf(etcs.dataOptions.level) >=0) { levelRestricted = false; }
					}
				}
				var transitionRestricted = false;
				if (restriction[i].t != undefined) {
					transitionRestricted = true;
					var aTransition = etcs.dataOptions.transition.split(etcs.prop.sepChar);
					switch (aTransition.length) {
						case 5: if (restriction[i].t.indexOf(aTransition[0]) >= 0 || restriction[i].t.indexOf(aTransition[1]) >= 0 || restriction[i].t.indexOf(aTransition[2]) >= 0 || restriction[i].t.indexOf(aTransition[3]) >= 0 || restriction[i].t.indexOf(aTransition[4]) >= 0) { transitionRestricted = false; } break;
						case 4: if (restriction[i].t.indexOf(aTransition[0]) >= 0 || restriction[i].t.indexOf(aTransition[1]) >= 0 || restriction[i].t.indexOf(aTransition[2]) >= 0 || restriction[i].t.indexOf(aTransition[3]) >= 0) { transitionRestricted = false; } break;
						case 3: if (restriction[i].t.indexOf(aTransition[0]) >= 0 || restriction[i].t.indexOf(aTransition[1]) >= 0 || restriction[i].t.indexOf(aTransition[2]) >= 0) { transitionRestricted = false; }break;
						case 2: if (restriction[i].t.indexOf(aTransition[0]) >= 0 || restriction[i].t.indexOf(aTransition[1]) >= 0) { transitionRestricted = false; } break;
						default: if (etcs.dataOptions.transition != "" && restriction[i].t.indexOf(etcs.dataOptions.transition) >=0) { transitionRestricted = false; }
					}
				}
				var screenRestricted = false;
				if (restriction[i].s != undefined) {
					screenRestricted = (etcs.dataOptions.screen != restriction[i].b);
				}
				isRestricted = (baselineRestricted || versionRestricted || levelRestricted || transitionRestricted);
				if (!isRestricted) break;
			}
		}
		return isRestricted;
	},

	onReadyMenu: function() {
		var querystring = (typeof(window.Storage) === "function") ? "" : document.location.search;
		for (var i=0; i<etcs.dataIndex.length; i++) {
			if (etcs.dataIndex[i].active && !etcs.funct.restrictMenu(etcs.dataIndex[i].restriction)) {
				var ulSecond = undefined;
				var href = etcs.dataIndex[i].code.replaceAll("\\.", etcs.prop.sepChar) + etcs.prop.htmlExt;
				var liFirst = etcs.funct.createDOMElement("li", {});
				liFirst.appendChild(etcs.funct.createDOMElement("a", {
					'href': href + querystring
				}, etcs.dataIndex[i].name));
				if (etcs.dataIndex[i].level2 != undefined) {
					ulSecond = etcs.funct.createDOMElement("ul", {
						'id': "collapse_" + (i+1),
						'className': "panel-collapse collapse scnd-menu"
					});
					var haveSecond = false;
					for (var j=0; j<etcs.dataIndex[i].level2.length; j++) {
						if (etcs.dataIndex[i].level2[j].active && !etcs.funct.restrictMenu(etcs.dataIndex[i].level2[j].restriction)) {
							haveSecond = true;
							var ulThird = undefined;
							var liSecond = etcs.funct.createDOMElement("li", {});
							liSecond.appendChild(etcs.funct.createDOMElement("a", {
								'href': href + querystring + "#" + etcs.dataIndex[i].level2[j].code
							}, etcs.dataIndex[i].level2[j].name));
							if (etcs.dataIndex[i].level2[j].level3 != undefined) {
								ulThird = etcs.funct.createDOMElement("ul", {
									'id': "collapse_" + (i+1) + "_" + (j+1),
									'className': "panel-collapse collapse"
								});
								var haveThird = false;
								for (var k=0; k<etcs.dataIndex[i].level2[j].level3.length; k++) {
									if (etcs.dataIndex[i].level2[j].level3[k].active && !etcs.funct.restrictMenu(etcs.dataIndex[i].level2[j].level3[k].restriction)) {
										haveThird = true;
										var liThird = etcs.funct.createDOMElement("li", {});
										liThird.appendChild(etcs.funct.createDOMElement("a", {
											'href': href + querystring + "#" +  etcs.dataIndex[i].level2[j].level3[k].code
										}, etcs.dataIndex[i].level2[j].level3[k].name));
										ulThird.appendChild(liThird);
									}
								}
								if (haveThird) {
									var plusLinkSecond = etcs.funct.createDOMElement("a", {
										'data-toggle': "collapse",
										'className': "submenu plusLink collapsed",
										'href': '#collapse_' + (i+1) + "_" + (j+1)
									});
									plusLinkSecond.appendChild(etcs.funct.createDOMElement("img", {
										'src': etcs.prop.imgMenuPlusSecond
									}));
									liSecond.appendChild(plusLinkSecond);
								}
							}
							if (ulThird != undefined) {
								liSecond.appendChild(ulThird);
							}
							ulSecond.appendChild(liSecond);
						}
					}
					if (haveSecond) {
						var plusLink = etcs.funct.createDOMElement("a", {
							'data-toggle': "collapse",
							'className': "submenu plusLink collapsed",
							'href': '#collapse_' + (i+1)
						});
						plusLink.appendChild(etcs.funct.createDOMElement("img", {
							'src': etcs.prop.imgMenuPlus
						}));
						liFirst.appendChild(plusLink);
					}
				}
				if (ulSecond != undefined) {
					liFirst.appendChild(ulSecond);
				}
				$("#ulMenu").append(liFirst);
			}
		}
		$('#ulMenu a.plusLink').on('click', function (e) {
			$(this).children().get(0).src = ($(this).children().get(0).src.indexOf('menos') >= 0) ? $(this).children().get(0).src.replace('menos', 'mas') : $(this).children().get(0).src.replace('mas', 'menos');
			$($(this).parent().children()[0]).css('font-weight', ($($(this).parent().children()[0]).css('font-weight') == "700") ? "400" : "700");
		});
	},

	onReadyFilter: function() {
		if (etcs.prop.preconfigured) {
			$("#confcheck").text(etcs.label.txtValues);
			$(".hidden-preconfig").hide();
			etcs.funct.loadFilterValues(etcs.dataOptions);
		} else {
			var data = etcs.funct.readStoredData(etcs.prop.filterStorageName);
			if (data != null) {
				etcs.funct.checkModalFilter("Baseline", data.hB, data.iB);
				etcs.funct.checkModalFilter("Version", data.hV, data.iV);
				etcs.funct.checkModalFilter("Level", data.hL, data.iL);
				etcs.funct.checkModalFilter("Transition", data.hT, data.iT);
				etcs.funct.checkModalFilter("Screen", data.hS, data.iS);
			} else if (document.location.search.length > 0) {
				etcs.funct.loadFilterValues(etcs.dataOptions);
				etcs.funct.checkModalFilter("Baseline", etcs.dataOptions.baseline);
				etcs.funct.checkModalFilter("Version", etcs.dataOptions.version + etcs.prop.sepChar);
				etcs.funct.checkModalFilter("Level", etcs.dataOptions.level + etcs.prop.sepChar);
				etcs.funct.checkModalFilter("Transition", etcs.dataOptions.transition + etcs.prop.sepChar);
				etcs.funct.checkModalFilter("Screen", etcs.dataOptions.screen);
			}
		}
		$("form.values img").on("mouseover", function() {
			this.src = this.src.replace(".png", "2.png");
		});			
		$("form.values img").on("mouseout", function() {
			this.src = this.src.replace("2.png", ".png");
		});
		$("#fBaseline").on("click", function() {
			var option = $("#mBaseline input[name='baseline']:checked").parent('label').text();
			if (option.length == 0) {
				$("#mBaseline label.error").html(etcs.label.selOption);
			} else {
				$("#iBaseline").removeClass("error");
				$("#iBaseline").html(option);
				var value = $("#mBaseline input[name='baseline']:checked").val();
				$("#hBaseline").val(value);
				if (value == "3M1" && $("#hVersion").val().length > 0 && $("#hVersion").val().indexOf("21" + etcs.prop.sepChar) >= 0) {
					$("#iVersion").html($("#iVersion").html().replace("2.1; ", ""));
					$("#hVersion").val($("#hVersion").val().replace("21" + etcs.prop.sepChar, ""));
					$("#mVersion input[name='2.1']").prop("checked", false);
				}
				$("#mBaseline").modal('hide');
			}
		});
		$("#mBaseline input[name='baseline']").on("click", function() {
			$("#mBaseline label.error").html('');
		});
		$("#fVersion").on("click", function() {
			var option = $("#mVersion input:checked");
			if (option.length == 0) {
				$("#mVersion label.error").html(etcs.label.selOptions);
			} else {
				var texts = "", values = "";
				for (var i=0; i<option.length; i++) {
					texts += option.get(i).name + "; ";
					values += option.get(i).value + etcs.prop.sepChar;
				}
				$("#iVersion").removeClass("error");
				$("#iVersion").html(texts);
				$("#hVersion").val(values);
				$("#mVersion").modal('hide');
			}
		});
		$("#mVersion input").on("click", function() {
			$("#mVersion label.error").html('');
		});
		$('#mVersion').on('show.bs.modal', function (e) {
			$(".exceptionVersion").prop("disabled", $("#hBaseline").val() == "3M1");
		});
		$("#fLevel").on("click", function() {
			var option = $("#mLevel input:checked");
			if (option.length == 0) {
				$("#mLevel label.error").html(etcs.label.selOptions);
			} else {
				var texts = "", values = "";
				for (var i=0; i<option.length; i++) {
					texts += option.get(i).name + "; ";
					values += option.get(i).value + etcs.prop.sepChar;
				}
				$("#iLevel").removeClass("error");
				$("#iLevel").html(texts);
				$("#hLevel").val(values);
				if ($("#hTransition").val().length > 0) {
					var options = $("#hTransition").val().split(etcs.prop.sepChar);
					for (var i=0; i<options.length - 1; i++) {
						var strToFind = options[i] + etcs.prop.sepChar;
						if (values.indexOf(strToFind) < 0) {
							$("#mTransition input[value='" + options[i] + "']").prop("checked", false);
							$("#iTransition").html($("#iTransition").html().replace($("#mTransition input[value='" + options[i] + "']").get(0).name + "; ", ""));
							$("#hTransition").val($("#hTransition").val().replace(options[i] + etcs.prop.sepChar, ""));
						}
					}
				}
				$("#mLevel").modal('hide');
			}
		});
		$("#mLevel input").on("click", function() {
			$("#mLevel label.error").html('');
		});
		$("#fTransition").on("click", function() {
			var option = $("#mTransition input:checked");
			var texts = "", values = "";
			for (var i=0; i<option.length; i++) {
				texts += option.get(i).name + "; ";
				values += option.get(i).value + etcs.prop.sepChar;
			}
			$("#iTransition").removeClass("error");
			$("#iTransition").html(texts);
			$("#hTransition").val(values);
			$("#mTransition").modal('hide');
		});
		$('#mTransition').on('show.bs.modal', function (e) {
			var aTransition = ['0', 'N', '1', '2', '3'];
			for (var i=0; i<aTransition.length; i++) {
				$("#mTransition input[value='" + aTransition[i] + "']").prop("disabled", $("#hLevel").val().indexOf(aTransition[i] + etcs.prop.sepChar) < 0);
			}
		});
		$("#fScreen").on("click", function() {
			var option = $("#mScreen input[name='screen']:checked").parent('label').text();
			if (option.length == 0) {
				$("#mScreen label.error").html(etcs.label.selOption);
			} else {
				$("#iScreen").removeClass("error");
				$("#iScreen").html(option);
				$("#hScreen").val($("#mScreen input[name='screen']:checked").val());
				$("#mScreen").modal('hide');
			}
		});
		$("#mScreen input[name='screen']").on("click", function() {
			$("#mScreen label.error").html('');
		});
		$("#fSubmit").on("click", function() {
			var myForm = document.fSubmit;
			if (etcs.prop.preconfigured) {
				document.location.href = myForm.action;
			} else {
				var submitError = false;
				if (myForm.hBaseline.value == "") {
					$("#iBaseline").html(etcs.label.selOption);
					$("#iBaseline").addClass("error");
					submitError = true;
				}
				if (myForm.hVersion.value == "") {
					$("#iVersion").html(etcs.label.selOptions);
					$("#iVersion").addClass("error");
					submitError = true;
				}
				if (myForm.hLevel.value == "") {
					$("#iLevel").html(etcs.label.selOptions);
					$("#iLevel").addClass("error");
					submitError = true;
				}
				if (myForm.hScreen.value == "") {
					$("#iScreen").html(etcs.label.selOption);
					$("#iScreen").addClass("error");
					submitError = true;
				}
				if (!submitError) {
					etcs.funct.storeData(etcs.prop.filterStorageName, {
						'iB': $("#iBaseline").html(), 'hB': myForm.hBaseline.value,
						'iV': $("#iVersion").html(), 'hV': myForm.hVersion.value,
						'iL': $("#iLevel").html(), 'hL': myForm.hLevel.value,
						'iT': $("#iTransition").html(), 'hT': myForm.hTransition.value,
						'iS': $("#iScreen").html(), 'hS': myForm.hScreen.value,
					});
					if (typeof(window.Storage) === "function") {
						document.location.href = myForm.action;
					} else {
						myForm.submit();
					}
				}
			}
		});
	},

	onReadyContent: function() {
		$("body").click(function(e) {
			etcs.funct.closeTooltip("#" + etcs.prop.tooltip);
		});
		$("abbr").on("click", function(e) {
			etcs.funct.openTooltip(etcs.prop.tooltip, $(this).get(0).title, e);
		});
		$("abbr").on("mouseout", function(e) {
			etcs.funct.closeTooltip("#" + etcs.prop.tooltip);
		});
		$("img.change-cl").on("click", function(e) {
			etcs.funct.showNameClauses();
			etcs.funct.storeClausesVisibility(true);
		});
		$("p.clause > span").on("click", function(e) {
			etcs.funct.hideNameClauses();
			etcs.funct.storeClausesVisibility(false);
		});
		$("#clauseEye").on("click", function() {
			if (!etcs.prop.showNameClauses) {
				etcs.funct.showNameClauses();
			} else {
				etcs.funct.hideNameClauses();
			}
			etcs.funct.storeClausesVisibility(!etcs.prop.showNameClauses);
		});
		$("p.clause > span").prop("title", etcs.label.hideEye);
		if (etcs.prop.showNameClauses) {
			etcs.funct.showNameClauses();
		} else {
			etcs.funct.hideNameClauses()
		}
		if (etcs.dataOptions != undefined) {
			etcs.funct.filterClauses(etcs.dataOptions);
			etcs.funct.filterHGroups();
		}
	},

	closeTooltip: function(element) {
		if ($(element).length > 0) {
			$(element).remove();
		}
	},

	openTooltip: function(element, txt, e) {
		e.stopPropagation();
		etcs.funct.closeTooltip(element);
		$("body").append(etcs.funct.createDOMElement('div', {
			'id': element
		}, txt));
		$("#" + element).css({
			'top': (e.pageY - 50) + "px",
            'left': (e.pageX - 20) + "px"
		});
	},

	storeClausesVisibility: function(visible) {
		etcs.prop.showNameClauses = visible;
		etcs.funct.storeData(etcs.prop.eyeStorageName, {
			showNameClauses: visible
		});
	},

	showNameClauses: function() {
		$("p.clause > span").show();
		$("img.change-cl").hide();
		$("#clauseEye").attr("title", etcs.label.hideEye);
		$("#clauseEye img").get(0).src = $("#clauseEye img").get(0).src.replace(".png", "2.png");
	},

	hideNameClauses: function() {
		$("p.clause > span").hide();
		$("img.change-cl").show();
		$("#clauseEye").attr("title", etcs.label.showEye);
		$("#clauseEye img").get(0).src = $("#clauseEye img").get(0).src.replace("2.png", ".png");
	},

	deleteSlash: function(str) {
		if (str != null && str.indexOf(etcs.prop.sepChar, str.length - 1) > 0) {
			str = str.substr(0, str.length - 1);
		}
		return str;
	},

	filterClauses: function(options) {
		var divSelector = "div.content div.";
		if (options.baseline == "3M1") {
			$(divSelector + "bsl-32").hide();
		} else if (options.baseline == "32") {
			$(divSelector + "bsl-3M1").hide();
		}
		if (options.screen == "S") {
			$(divSelector + "tec-T").hide();
		} else if (options.screen == "T") {
			$(divSelector + "tec-S").hide();
		}
		if (options.version != null) {
			var aVersion = options.version.split(etcs.prop.sepChar);
			for (var i=0; i<etcs.prop.aVer.length; i++) {
				switch (aVersion.length) {
					case 4:
						if (etcs.prop.aVer[i].indexOf(aVersion[0]) < 0 && etcs.prop.aVer[i].indexOf(aVersion[1]) < 0 && etcs.prop.aVer[i].indexOf(aVersion[2]) < 0 && etcs.prop.aVer[i].indexOf(aVersion[3]) < 0) $(divSelector + "ver-" + etcs.prop.aVer[i]).hide();
						break;
					case 3:
						if (etcs.prop.aVer[i].indexOf(aVersion[0]) < 0 && etcs.prop.aVer[i].indexOf(aVersion[1]) < 0 && etcs.prop.aVer[i].indexOf(aVersion[2]) < 0) $(divSelector + "ver-" + etcs.prop.aVer[i]).hide();
						break;
					case 2:
						if (etcs.prop.aVer[i].indexOf(aVersion[0]) < 0 && etcs.prop.aVer[i].indexOf(aVersion[1]) < 0) $(divSelector + "ver-" + etcs.prop.aVer[i]).hide();
						break;
					default:
						if (etcs.prop.aVer[i].indexOf(options.version) < 0) $(divSelector + "ver-" + etcs.prop.aVer[i]).hide();
				}
			}
		}
		if (options.level != null) {
			var aLevel = options.level.split(etcs.prop.sepChar);
			for (var i=0; i<etcs.prop.aLev.length; i++) {
				switch (aLevel.length) {
					case 5:
						if (etcs.prop.aLev[i].indexOf(aLevel[0]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[1]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[2]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[3]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[4]) < 0) $(divSelector + "lev-" + etcs.prop.aLev[i]).hide();
						break;
					case 4:
						if (etcs.prop.aLev[i].indexOf(aLevel[0]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[1]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[2]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[3]) < 0) $(divSelector + "lev-" + etcs.prop.aLev[i]).hide();
						break;
					case 3:
						if (etcs.prop.aLev[i].indexOf(aLevel[0]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[1]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[2]) < 0) $(divSelector + "lev-" + etcs.prop.aLev[i]).hide();
						break;
					case 2:
						if (etcs.prop.aLev[i].indexOf(aLevel[0]) < 0 && etcs.prop.aLev[i].indexOf(aLevel[1]) < 0) $(divSelector + "lev-" + etcs.prop.aLev[i]).hide();
						break;
					default:
						if (etcs.prop.aLev[i].indexOf(options.level) < 0) $(divSelector + "lev-" + etcs.prop.aLev[i]).hide();
				}
			}
		}
		if (options.transition != null) {
			if (options.transition.length > 0) {
				var aTrans = options.transition.split(etcs.prop.sepChar);
				for (var i=0; i<etcs.prop.aLev.length; i++) {
					switch (aTrans.length) {
						case 5:
							if (etcs.prop.aLev[i].indexOf(aTrans[0]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[1]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[2]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[3]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[4]) < 0) $(divSelector + "ltr-" + etcs.prop.aLev[i]).hide();
							break;
						case 4:
							if (etcs.prop.aLev[i].indexOf(aTrans[0]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[1]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[2]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[3]) < 0) $(divSelector + "ltr-" + etcs.prop.aLev[i]).hide();
							break;
						case 3:
							if (etcs.prop.aLev[i].indexOf(aTrans[0]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[1]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[2]) < 0) $(divSelector + "ltr-" + etcs.prop.aLev[i]).hide();
							break;
						case 2:
							if (etcs.prop.aLev[i].indexOf(aTrans[0]) < 0 && etcs.prop.aLev[i].indexOf(aTrans[1]) < 0) $(divSelector + "ltr-" + etcs.prop.aLev[i]).hide();
							break;
						default:
							if (etcs.prop.aLev[i].indexOf(options.transition) < 0) $(divSelector + "ltr-" + etcs.prop.aLev[i]).hide();
					}
				}
			} else {
				for (var i=0; i<etcs.prop.aLev.length; i++) {
					$(divSelector + "ltr-" + etcs.prop.aLev[i]).hide();
				}
			}
		}
	},

	filterHGroups: function() {
		$("div.content div.group-h3").each(function() {
			var hasVisible = false;
			var jQElement = $(this);
			jQElement.children().each(function() {
				if ($(this).prop("nodeName") != "A" && $(this).prop("nodeName") != "H3") {
					if ($(this).is(":visible")) {
						hasVisible = true;
						return false;
					}
				}
			});
			if (!hasVisible) {
				jQElement.hide();
			}
		});
		$("div.content div.group-h2").each(function(index) {
			var hasVisible = false;
			var jQElement = $(this);
			jQElement.children().each(function() {
				if ($(this).prop("nodeName") != "A" && $(this).prop("nodeName") != "H2") {
					if ($(this).is(":visible")) {
						hasVisible = true;
						return false;
					}
				}
			});
			if (!hasVisible) {
				jQElement.hide();
			}
		});
	},

	isConfigured: function() {
		var preconfigured = false;
		if (etcs.dataOptions != undefined) {
			if (etcs.dataOptions.baseline != "" && etcs.dataOptions.baseline != "" && etcs.dataOptions.level != "" && etcs.dataOptions.screen != "") {
				preconfigured = true;
			}
		}
		return preconfigured;
	},

	loadFilterValues: function(data) {
		$("#iBaseline").html($("#mBaseline input[value='" + data.baseline + "']").parent().text());
		$("#iScreen").html($("#mScreen input[value='" + data.screen + "']").parent().text());
		if (data.version != null) {
			var aVer = data.version.split(etcs.prop.sepChar);
			var outVersion = "";
			for (var i=0; i<aVer.length; i++) {
				outVersion += $("#mVersion input[value='" + aVer[i] + "']").parent().text() + "; ";
			}
			$("#iVersion").html(outVersion);
		}
		if (data.level != null) {
			var aLev = data.level.split(etcs.prop.sepChar);
			var outLevel = "";
			for (var i=0; i<aLev.length; i++) {
				outLevel += $("#mLevel input[value='" + aLev[i] + "']").parent().text() + "; ";
			}
			$("#iLevel").html(outLevel);
		}
		if (data.transition != null && data.transition != "") {
			var aTra = data.transition.split(etcs.prop.sepChar);
			var outTransition = "";
			for (var i=0; i<aTra.length; i++) {
				outTransition += $("#mTransition input[value='" + aTra[i] + "']").parent().text() + "; ";
			}
			$("#iTransition").html(outTransition);
		}
	},

	checkModalFilter: function(attribute, dataH, dataI) {
		if (dataH != undefined && dataH != etcs.prop.sepChar) {
			if (dataI != undefined) {
				$("#i" + attribute).html(dataI);
			}
			$("#h" + attribute).val(dataH);
			var isArray = (dataH.indexOf(etcs.prop.sepChar) >= 0) ? 1 : 0;
			var aData = dataH.substr(0, dataH.length - isArray).split(etcs.prop.sepChar);
			for (var i=0; i<aData.length; i++) {
				$("#m" + attribute + " input[value='" + aData[i] + "']").prop("checked", true);
			}
		}
	},

	storeData: function(item, data) {
		if (typeof(window.Storage) === "function") {
			window.localStorage.setItem(item, JSON.stringify(data));
		}
	},

	readStoredData: function(item) {
		var data = null;
		if (typeof(window.Storage) === "function") {
			data = JSON.parse(window.localStorage.getItem(item));
		}
		return data;
	},

	getParameterByName:function(N){N=N.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var x=new RegExp("[\\?&]"+N+"=([^&#]*)"),r=x.exec(location.search);return(r===null)?null:decodeURIComponent(r[1].replace(/\+/g," "));},

	createDOMElement:function(e,s,t){var o=document.createElement(e);for(var a in s){if(a!='onclick'){if(a.indexOf(etcs.prop.sepChar)<0){eval("o."+a+"=s[a];");}else{eval("o.setAttribute('"+a+"',s[a]);");}}else{o.href="#";eval("o.onclick=function(){"+s[a]+"return false;}");}}if(t!=undefined){o.appendChild(document.createTextNode(t));}return(o);}
};

$(document).ready(function() {
	etcs.funct.onReady();
	if ($("#iagree").length > 0) {
		etcs.funct.onReadyHome();
	}
	if ($("form.values").length > 0) {
		etcs.funct.onReadyFilter();
	}
	if ($("#ulMenu").length > 0) {
		etcs.funct.onReadyMenu();
	}
	if ($("main div.content").length > 0) {
		etcs.funct.onReadyContent();
	}
});

if(!String.prototype.replaceAll){String.prototype.replaceAll=function(f,r){return this.replace(new RegExp(f,'g'),r);};}
